% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplifyArtifactData.R,
%   R/simplifyFragmentData.R
\name{simplifyArtifactData}
\alias{simplifyArtifactData}
\alias{simplifyFragmentData}
\title{Simplify Coarse Fraction Data}
\usage{
simplifyArtifactData(
  art,
  id.var,
  vol.var = "huartvol",
  nullFragsAreZero = nullFragsAreZero,
  ...
)

simplifyFragmentData(
  rf,
  id.var,
  vol.var = "fragvol",
  prefix = "frag",
  nullFragsAreZero = TRUE,
  msg = "rock fragment volume",
  ...
)
}
\arguments{
\item{art}{a \code{data.frame} object, typically returned from NASIS, see details}

\item{id.var}{character vector with the name of the column containing an ID
that is unique among all horizons in \code{rf}}

\item{vol.var}{character vector with the name of the column containing the coarse fragment volume. Default \code{"fragvol"} or \verb{"huartvol}".}

\item{nullFragsAreZero}{should fragment volumes of NULL be interpreted as 0? (default: \code{TRUE}), see details}

\item{...}{Additional arguments passed to sieving function (e.g. \code{sieves} a named numeric containing sieve size thresholds with class name)}

\item{rf}{a \code{data.frame} object, typically returned from NASIS, see
details}

\item{prefix}{a character vector prefix for input}

\item{msg}{Identifier of data being summarized. Default is \code{"rock fragment volume"} but this routine is also used for \code{"surface fragment cover"}}
}
\description{
Simplify multiple coarse fraction (>2mm) records by horizon.
}
\details{
This function is mainly intended for processing of NASIS pedon/component
data which contains multiple coarse fragment descriptions per horizon.
\code{simplifyFragmentData} will "sieve out" coarse fragments into the USDA
classes, split into hard and para- fragments. Likewise, \code{simplifyArtifactData} will sieve out human artifacts, and split total volume into "cohesive", "penetrable", "innocuous", and "persistent".

These functions can be applied to data sources other than NASIS by careful use of the \code{id.var} and \code{vol.var} arguments.
\itemize{
\item \code{rf} must contain rock or other fragment volumes in the column "fragvol" (or be specified with \code{vol.var}), fragment size (mm) in columns "fragsize_l", "fragsize_r", "fragsize_h", fragment cementation class in "fraghard" and flat/non-flat in "fragshp".
\item \code{art} must contain artifact volumes in the column "huartvol" (or be specified with \code{vol.var}), fragment size (mm) in columns "huartsize_l", "huartsize_r", "huartsize_h", artifact cementation class in "huarthard" and flat/non-flat in "huartshp".
}

Examples:
\itemize{
\item \href{http://ncss-tech.github.io/AQP/soilDB/KSSL-demo.html}{KSSL data}
}
}
\author{
D.E. Beaudette, A.G Brown
}
\keyword{manip}
