% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lists.R
\name{survey_countries}
\alias{survey_countries}
\title{List all countries contained in a survey}
\usage{
survey_countries(survey, country.column = "country", ...)
}
\arguments{
\item{survey}{a DOI or url to get the survey from, or a \code{\link[=survey]{survey()}} object (in which case only cleaning is done).}

\item{country.column}{column in the survey indicating the country}

\item{...}{further arguments for \code{\link[=get_survey]{get_survey()}}}
}
\value{
list of countries
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\details{
\code{survey_countries()} has been deprecated in favour of using
\code{contactsurveys::download_survey()}, and \code{\link[=load_survey]{load_survey()}}, and then
exploring the country column yourself.
}
\examples{
data(polymod)
survey_countries(polymod)
## --> we now recommend
\dontrun{
doi_peru <- "10.5281/zenodo.1095664" # nolint
# download the data with the contactsurveys package
peru_survey <- contactsurveys::download_survey(doi_peru)
# load the survey with socialmixr
peru_data <- socialmixr::load_survey(peru_survey)
# find the unique country - assuming your data has a "country" column:
unique(peru_data$participants$country)
}
}
