% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_methods.R
\name{[.sk}
\alias{[.sk}
\title{Extract a sk list element (single-bracket access)}
\usage{
\method{[}{sk}(x, i = NULL, j = NULL, drop = FALSE, ...)
}
\arguments{
\item{x}{a sk object}

\item{i}{column-vectorized index}

\item{j}{index of layer (only for multi-layer x)}

\item{drop}{ignored}

\item{...}{ignored}
}
\value{
a list, vector, or matrix (see description)
}
\description{
Copies the specified list element or grid point value
}
\details{
Behavior depends on the class of i. For character vectors this extracts the named list
entries of x. For numeric, it accesses the vectorized grid data values. For multi-layer
objects, a layer can be specified in j.

the default \code{NULL} for \code{i} and \code{j} is treated as numeric, and is shorthand for all
indices. For example if \code{x} has a single-layer \code{x[]} returns all grid data in a vector.
If \code{x} is multi-layer \code{x[,1]} all grid data from the first layer, and \code{x[]} returns all
layers, as a matrix.
}
\examples{
# define a sk list and extract two of its elements
g = sk_validate(list(gval=stats::rnorm(4^2), gdim=4, gres=0.5))
g[c('gdim', 'gres')]

# display all the grid data as a vector or a matrix
g[]
matrix(g[], dim(g))

# extract a particular grid point or a subset
g[1]
g[seq(5)]

}
