% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_deparse.R
\name{smooth_deparse}
\alias{smooth_deparse}
\title{Deparse}
\usage{
smooth_deparse(id, day, treatment)
}
\arguments{
\item{id}{Unique identifier of the patient.}

\item{day}{Day of the treatment.}

\item{treatment}{A character vector representing the type of treatment given to each patient.}
}
\value{
A data.frame with the following structure:
\describe{
\item{id}{A character vector representing the unique identifier for each patient.}
\item{start_date}{Start date of the treatment.}
\item{end_date}{End date of the treatment.}
\item{treatment}{A character vector representing the type of treatment given to each patient.}
}
}
\description{
Transforms the Data with a Row by Date to a Row by Individual.
}
\examples{

library(smoothy)
library(dplyr)

data(drugstreatment)

my_data <- filter(drugstreatment, id == "01f13c15-d9f1-4106-a04f-976c457edd0a")

structured_df <- smooth_parse(
  id = my_data$id,
  start_date = my_data$start_date,
  end_date = my_data$end_date,
  drug = my_data$drug,
  study_from = "1970-01-01",
  study_to = "1975-01-01"
)

head(structured_df)

id = structured_df$id
treatment = structured_df$treatment
day = structured_df$day
N = structured_df$N
width = 61

smoothed <- smooth_algorithm(id = id, treatment = treatment, day = day, N = N, width = width)

head(smoothed)

deparsed_treatment <- smooth_deparse(smoothed$id, smoothed$day, smoothed$treatment)
deparsed_smothed <- smooth_deparse(smoothed$id, smoothed$day, smoothed$smoothed_treatment)

}
