% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{minimizeFunction}
\alias{minimizeFunction}
\title{Minimize the objective function of an unsmoothed or smoothed regression operator with respect to \eqn{betavector} using BFGS.}
\usage{
minimizeFunction(p, obj, objgrad)
}
\arguments{
\item{p}{The dimension of the unknown parameters (regression coefficients).}

\item{obj}{The objective function of the regression operator as a function of \eqn{betavector}.}

\item{objgrad}{The gradient function of the regression operator as a function of \eqn{betavector}.}
}
\value{
The estimator \eqn{betavector} (minimizer) of the regression operator.
}
\description{
Minimize the objective function of an unsmoothed or smoothed regression operator with respect to \eqn{betavector} using BFGS.
}
\examples{
library(smoothedLasso)
n <- 100
p <- 500
betavector <- runif(p)
X <- matrix(runif(n*p),nrow=n,ncol=p)
y <- X \%*\% betavector
lambda <- 1
temp <- standardLasso(X,y,lambda)
obj <- function(z) objFunctionSmooth(z,temp$u,temp$v,temp$w,mu=0.1)
objgrad <- function(z) objFunctionSmoothGradient(z,temp$w,temp$du,temp$dv,temp$dw,mu=0.1)
print(minimizeFunction(p,obj,objgrad))

}
\references{
Hahn, G., Lutz, S., Laha, N., and Lange, C. (2020). A framework to efficiently smooth L1 penalties for linear regression. bioRxiv:2020.09.17.301788.
}
