% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{single_exp}
\alias{single_exp}
\alias{single_matern3}
\alias{single_matern5}
\alias{single-matern}
\alias{single_matern}
\alias{single_gauss}
\title{Matern covariance function (scalar - generic)}
\usage{
single_exp(d, sigsq, phi)

single_matern3(d, sigsq, phi)

single_matern5(d, sigsq, phi)

single_matern(d, sigsq, phi, nu)

single_gauss(d, sigsq, phi)
}
\arguments{
\item{d}{a scalar representing the distance on which it is desired to
evaluate the covariance function.}

\item{sigsq}{the \eqn{\sigma^2} parameter from the Matern covariance
function.}

\item{phi}{the \eqn{\phi} parameter from the Matern covariance function,
controls the range of the spatial dependence.}

\item{nu}{the \eqn{\nu} parameter from the Matern covariance function,
controls the differentiability of the process.}
}
\value{
a scalar representing the (matern) covariance between two
observations \code{d} apart of each other.
}
\description{
Computing the Matern covariance function for a scalar distance,
adapted from \code{geoR}.
}
\details{
\code{single_matern3} and \code{single_matern5} are optimized for
when \eqn{\nu} is 1.5 or 2.5, respectively. Similarly, \code{single_exp}
and \code{single_gauss} represent the cases where \eqn{\nu = 0.5} or
\eqn{\nu \to \infty}. In other words, they are the exponential and
Gaussian covariance functions.
}
\seealso{
\code{\link{single_matern3}}, \code{\link{single_matern5}}
\code{\link{single_exp}}, \code{\link{mat_cov}}
}
\keyword{internal}
