% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlf.test.R
\name{mlf.test}
\alias{mlf.test}
\title{Maxima Likelihood First Scan Test}
\usage{
mlf.test(
  coords,
  cases,
  pop,
  w,
  ex = sum(cases)/sum(pop) * pop,
  nsim = 499,
  alpha = 0.1,
  ubpop = 0.5,
  ubd = 0.5,
  longlat = FALSE,
  cl = NULL
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions in the form (x, y) or
(longitude, latitude) is using great circle distance.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{w}{A binary spatial adjacency matrix for the
regions.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{nsim}{The number of simulations from which to
compute the p-value.}

\item{alpha}{The significance level to determine whether
a cluster is signficant.  Default is 0.10.}

\item{ubpop}{The upperbound of the proportion of the
total population to consider for a cluster.}

\item{ubd}{A proportion in (0, 1].  The distance of
potential clusters must be no more than \code{ubd * m},
where \code{m} is the maximum intercentroid distance
between all coordinates.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used. If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
It can also be \code{"future"} to use a future backend (see Details),
\code{NULL} (default) refers to sequential evaluation.
}
}
\value{
Returns a list of length two of class scan. The
  first element (clusters) is a list containing the
  significant, non-ovlappering clusters, and has the the
  following components: \item{locids}{The location ids of
  regions in a significant cluster.} \item{pop}{The total
  population in the cluser window.} \item{cases}{The
  observed number of cases in the cluster window.}
  \item{expected}{The expected number of cases in the
  cluster window.} \item{smr}{Standarized mortaility
  ratio (observed/expected) in the cluster window.}
  \item{rr}{Relative risk in the cluster window.}
  \item{loglikrat}{The loglikelihood ratio for the
  cluster window (i.e., the log of the test statistic).}
  \item{pvalue}{The pvalue of the test statistic
  associated with the cluster window.} \item{w}{The
  adjacency matrix of the cluster.} \item{r}{The maximum
  radius of the cluster (in terms of intercentroid
  distance from the starting region).} The second element
  of the list is the centroid coordinates.  This is
  needed for plotting purposes.
}
\description{
\code{mlf.test} implements the Maxima Likelihood First
scan test of Yao et al. (2011), which is actually a
special case of the Dynamic Minimum Spanning Tree of
Assuncao et al. (2006).  Find the single region that
maximizes the likelihood ratio test statistic.  Starting
with this single region as a current zone, new candidate
zones are constructed by combining the current zone with
the connected region that maximizes the likelihood ratio
test statisic.  This procedure is repeated until the
population and/or distance upper bound is reached.
}
\details{
Only a single candidate zone is ever returned because the
algorithm only constructs a single sequence of starting
zones, and overlapping zones are not returned.  Only the
zone that maximizes the likelihood ratio test statistic
is returned.
}
\examples{
data(nydf)
data(nyw)
coords <- with(nydf, cbind(longitude, latitude))
out <- mlf.test(
  coords = coords, cases = floor(nydf$cases),
  pop = nydf$pop, w = nyw,
  alpha = 0.12, longlat = TRUE,
  nsim = 10, ubpop = 0.1, ubd = 0.5
)
plot(out)
}
\references{
Yao, Z., Tang, J., & Zhan, F. B. (2011).
  Detection of arbitrarily-shaped clusters using a
  neighbor-expanding approach: A case study on murine
  typhus in South Texas. International journal of health
  geographics, 10(1), 1.

  Assuncao, R.M., Costa, M.A., Tavares, A. and Neto,
  S.J.F. (2006). Fast detection of arbitrarily shaped
  disease clusters, Statistics in Medicine, 25, 723-742.
}
\seealso{
\code{\link{print.smerc_cluster}},
\code{\link{summary.smerc_cluster}},
\code{\link{plot.smerc_cluster}},
\code{\link{scan.stat}}, \code{\link{scan.test}}
}
\author{
Joshua French
}
