% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignplot.R
\name{alignplot}
\alias{alignplot}
\title{Function to plot Procrustes aligned MDS configurations}
\usage{
alignplot(objectlist, reference, layoutmat = NULL, mains = NULL, ...)
}
\arguments{
\item{objectlist}{a list of object of class smacofP or smacofB (or anything with a $conf slot where the configuration is). Thse are the plots to Procrustes adjust.}

\item{reference}{the reference configuration/matrix}

\item{layoutmat}{a matrix layout for the plot region. It is the 'mat' argument to 'layout'. If missing, the function attempts to create a layout that can hold all plots, but it is not very smart.}

\item{mains}{a character string of headings for each plot. It must be of length(objectlist).}

\item{...}{additional arguments passed to the confplot of 'plot.smacofP'. See 'plot.smacof' for the options.}
}
\value{
no return value; just plots
}
\description{
This plots a series of Procrustes aligned configuration plots, aligned to the reference configuration.
}
\examples{
dis<-as.matrix(smacof::kinshipdelta)
res1<-powerStressMin(dis)
res0<-smacof::mds(dis)
res2<-smacof::mds(dis,type="ordinal")
alignplot(list(res1,res2),reference=res0$conf,mains=c("pstress","ordinal"),layoutmat=c(1,2))
}
