% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.slouch}
\alias{plot.slouch}
\title{Plot Grid Search}
\usage{
\method{plot}{slouch}(x, theta = 30, phi = 30, expand = 0.5, shade = 0.75, ...)
}
\arguments{
\item{x}{An object of class 'slouch'}

\item{theta, phi}{angles defining the viewing direction.
    \code{theta} gives the azimuthal direction and \code{phi}
    the colatitude.}

\item{expand}{a expansion factor applied to the \code{z}
    coordinates. Often used with \code{0 < expand < 1} to shrink the
    plotting box in the \code{z} direction.}

\item{shade}{the shade at a surface facet is computed as
    \code{((1+d)/2)^shade}, where \code{d} is the dot product of
    a unit vector normal to the facet and a unit vector in the
    direction of a light source.  Values of \code{shade} close
    to one yield shading similar to a point light source model
    and values close to zero produce no shading.  Values in the
    range 0.5 to 0.75 provide an approximation to daylight
    illumination.}

\item{...}{Additional parameters passed to persp(...) or plot(...)}
}
\description{
Graphical plot of parameter space traversed by the grid search.
}
\examples{

data(artiodactyla)
data(neocortex)

neocortex <- neocortex[match(artiodactyla$tip.label, neocortex$species), ]

m0 <- slouch.fit(phy = artiodactyla,
                 hl_values = seq(0.001, 50, length.out = 15),
                 vy_values = seq(0.001, 3, length.out = 15),
                 species = neocortex$species,
                 response = neocortex$body_mass_g_log_mean,
                 mv.response = neocortex$body_mass_g_log_varmean,
                 fixed.fact = neocortex$diet)
                 
plot(m0)
}
