% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motion_detectors.R
\name{motion_detectors}
\alias{motion_detectors}
\alias{max_velocity_detector}
\alias{max_velocity_detector_legacy}
\alias{virtual_beam_cross_detector}
\title{Motion detector for Ethocope data}
\usage{
max_velocity_detector(
  data,
  time_window_length,
  velocity_correction_coef = 0.003,
  masking_duration = 6
)

max_velocity_detector_legacy(data, velocity_threshold = 0.006)

virtual_beam_cross_detector(data, time_window_length)
}
\arguments{
\item{data}{\link[data.table:data.table]{data.table::data.table} containing behavioural variables of \emph{a single animal} (no id).
It must have the columns \code{xy_dist_log10x1000}(for computing subpixel velocity),
\code{x}(beam cross), \code{t} and \code{has_interacted} (whether a stimulus was delivered).}

\item{time_window_length}{number of seconds to be used by the motion classifier.
This corresponds to the sampling period of the output data.}

\item{velocity_correction_coef}{an empirical coefficient to correct velocity with respect
to variable framerate.}

\item{masking_duration}{number of seconds during which any movement is ignored (velocity is set to 0) after
a stimulus is delivered (a.k.a. interaction).}

\item{velocity_threshold}{uncorrected velocity above which an animal is classified as `moving' (for the legacy version).}
}
\value{
an object of the same type as \code{data} (i.e. \link[data.table:data.table]{data.table::data.table} or \link[behavr:behavr]{behavr::behavr})  with additional columns:
\itemize{
\item \code{moving} Logical, TRUE iff. motion was detected.
\item \code{beam_crosses} The number of beam crosses
(when the animal crosses x = 0.5 -- that is the midpoint of the region of interest) within the time window
\item \code{max_velocity} The maximal velocity within the time window.
The resulting data is sampled at a period equals to \code{time_window_length}.
}
}
\description{
Defines whether a \emph{single animal} is moving according to:
}
\details{
\itemize{
\item Validated and corrected subpixel velocity (\link{max_velocity_detector}), the most rigorous
\item Uncorrected subpixel velocity (\link{max_velocity_detector_legacy})
\item Crossing a virtual beam in the middle of the region of interest (\link{virtual_beam_cross_detector})
}

\link{max_velocity_detector} is the default movement classification for real-time ethoscope experiments.
It is benchmarked against human-generated ground truth.

These functions are \emph{rarely called directly}, but typically used is in the context of \link{sleep_annotation}.
}
\seealso{
\itemize{
\item \link{sleep_annotation} -- which requieres a motion detector
}
}
