% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{six_user_create}
\alias{six_user_create}
\title{Create a user, magically}
\usage{
six_user_create(
  username,
  path = NULL,
  permission_boundary = NULL,
  tags = NULL,
  copy_to_cb = TRUE
)
}
\arguments{
\item{username}{(character) A user name. required}

\item{path}{(character) The path for the user name. optional.
If it is not included, it defaults to a slash (/).}

\item{permission_boundary}{(character) The ARN of the managed policy
that is used to set the permissions boundary for the user. optional}

\item{tags}{(list) A list of tags that you want to attach to the new user.
optional}

\item{copy_to_cb}{(logical) Copy to clipboard. Default: \code{FALSE}. See
section "Clipboard" below for more details.}
}
\value{
NULL invisibly. A draft email is copied to your clipboard
}
\description{
Create a user, magically
}
\details{
See \code{\link[=aws_user_create]{aws_user_create()}} for more details.
This function creates a user, adds policies so the
user can access their own account, and grants them an access
key. Add more policies using \verb{aws_polic*} functions
}
\section{What is magical}{

\itemize{
\item Adds a \code{UserInfo} policy to your account if doesn't exist yet
\item Attaches \code{UserInfo} policy to the user created
\item Grants an access key, copying an email template to your clipboard
}
}

\examples{
\dontshow{if (interactive() && aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
name <- random_user()
six_user_create(name)

# cleanup
six_user_delete(name)
\dontshow{\}) # examplesIf}
}
\seealso{
Other users: 
\code{\link{aws_user}()},
\code{\link{aws_user_access_key}()},
\code{\link{aws_user_access_key_delete}()},
\code{\link{aws_user_add_to_group}()},
\code{\link{aws_user_create}()},
\code{\link{aws_user_current}()},
\code{\link{aws_user_delete}()},
\code{\link{aws_user_exists}()},
\code{\link{aws_users}()},
\code{\link{six_user_delete}()}

Other magicians: 
\code{\link{six_admin_setup}()},
\code{\link{six_bucket_delete}()},
\code{\link{six_bucket_upload}()},
\code{\link{six_file_upload}()},
\code{\link{six_user_delete}()}
}
\concept{magicians}
\concept{users}
