% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_grid_systems.R
\name{sits_roi_to_tiles}
\alias{sits_roi_to_tiles}
\title{Find tiles of a given ROI and Grid System}
\usage{
sits_roi_to_tiles(roi, crs = NULL, grid_system = "MGRS")
}
\arguments{
\item{roi}{Region of interest (see notes below).}

\item{crs}{Coordinate Reference System (CRS) of the roi.
(see details below).}

\item{grid_system}{Grid system to be used for the output images.
(Default is "MGRS")}
}
\value{
A \code{sf} object with the intersect tiles with three columns
tile_id, epsg, and the percentage of coverage area.
}
\description{
Given an ROI and grid system, this function finds the
intersected tiles and returns them as an SF object.
}
\note{
To define a \code{roi} use one of:
     \itemize{
       \item{A path to a shapefile with polygons;}
       \item{A \code{sfc} or \code{sf} object from \code{sf} package;}
       \item{A \code{SpatExtent} object from \code{terra} package;}
       \item{A named \code{vector} (\code{"lon_min"},
            \code{"lat_min"}, \code{"lon_max"}, \code{"lat_max"}) in WGS84;}
       \item{A named \code{vector} (\code{"xmin"}, \code{"xmax"},
             \code{"ymin"}, \code{"ymax"}) with XY coordinates.}
      }

     Defining a region of interest using \code{SpatExtent} or XY values not
     in WGS84 requires the \code{crs} parameter to be specified.

     The \code{grid_system} parameter allows the user to
     reproject the files to a grid system which is
     different from that used in the ARD image collection of
     the could provider. Currently, the package supports
     the use of MGRS grid system and those used by the Brazil
     Data Cube ("BDC_LG_V2" "BDC_MD_V2" "BDC_SM_V2").
}
\examples{
if (sits_run_examples()) {
# Defining a ROI
roi <- c(
  lon_min = -64.037,
  lat_min = -9.644,
  lon_max = -63.886,
  lat_max = -9.389
)
# Finding tiles
tiles <- sits_roi_to_tiles(roi, grid_system = "MGRS")
}
}
\author{
Felipe Carvalho, \email{felipe.carvalho@inpe.br}

Felipe Carlos, \email{efelipecarlos@gmail.com}
}
