% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverseScHaz.R
\name{inverseScHaz}
\alias{inverseScHaz}
\title{Wrapper for inverse cumulative hazard}
\usage{
inverseScHaz(
  p,
  t,
  lower,
  upper,
  eta,
  nu,
  phi,
  at_risk,
  tol = 1e-09,
  max_iter = 100
)
}
\arguments{
\item{p}{The random variable (typically \code{-log(U)}).}

\item{t}{Current time.}

\item{lower}{Lower bound for root finding.}

\item{upper}{Upper bound for root finding.}

\item{eta}{Numeric vector of shape parameters.}

\item{nu}{Numeric vector of scale parameters.}

\item{phi}{Numeric vector of multiplicative effects.}

\item{at_risk}{Numeric vector indicating at-risk indicators for each event type.}

\item{tol}{Numeric tolerance for root-finding. Default is 1e-9.}

\item{max_iter}{Maximum iterations. Default is 100.}
}
\value{
A numeric scalar, the root \code{u}.
}
\description{
A wrapper around the Rcpp function \code{inverseScHaz}, used to find the inverse
by numeric methods in case of no simple analytical solution.
}
\examples{
eta <- c(0.1, 0.1)
nu <- c(1.1, 1.1)
phi <- c(1, 1)
at_risk <- c(1, 1)
inverseScHaz(0.5, t = 0, lower = 1e-15, upper = 200, eta, nu, phi, at_risk)
}
