% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphaSimDisease.R
\name{alphaSimDisease}
\alias{alphaSimDisease}
\title{Simulation and Estimation in Setting Disease with Modified Shape Parameter of Disease Process}
\usage{
alphaSimDisease(
  N = 10000,
  alpha = 0.5,
  tau = 5,
  years_lost = FALSE,
  a0 = 1,
  eta = rep(0.1, 3),
  nu = rep(1.1, 3),
  beta_L0_D = 0.5,
  beta_L0_L = 2,
  beta_L_D = 1,
  beta_A0_D = -0.1,
  beta_A0_L = -1,
  lower = 10^(-30),
  upper = 200,
  cens = 1,
  gen_A0 = NULL,
  return_data = FALSE,
  beta_L_D_t_prime = 0,
  t_prime = NULL
)
}
\arguments{
\item{N}{Integer. Number of individuals to simulate. Default is 10,000.}

\item{alpha}{Numeric scalar. Multiplicative factor applied to the disease process shape parameter \eqn{\eta}.}

\item{tau}{Numeric scalar. Time horizon at which proportions are computed.}

\item{years_lost}{Logical. If \code{TRUE}, computes years lost instead of proportions.}

\item{a0}{Binary (0/1). Specifies the group for comparison.}

\item{eta}{Numeric vector of length 3. Shape parameters for Weibull hazards (default \code{rep(0.1, 3)}).}

\item{nu}{Numeric vector of length 3. Scale parameters for Weibull hazards (default \code{rep(1.1, 3)}).}

\item{beta_L0_D}{Numeric scalar. Effect of baseline covariate on death risk (default 0.5).}

\item{beta_L0_L}{Numeric scalar. Effect of baseline covariate on covariate risk (default 2).}

\item{beta_L_D}{Numeric scalar. Effect of covariate process on death risk (default 1).}

\item{beta_A0_D}{Numeric scalar. Effect of baseline treatment on death risk (default -0.1).}

\item{beta_A0_L}{Numeric scalar. Effect of baseline treatment on covariate risk (default -1).}

\item{lower}{Numeric scalar. Lower bound for root-finding in hazard inversion (default 1e-30).}

\item{upper}{Numeric scalar. Upper bound for root-finding in hazard inversion (default 200).}

\item{cens}{Binary scalar. Indicates whether individuals are at risk of censoring (default \code{1}).}

\item{gen_A0}{Function. Function to generate the baseline treatment covariate A0. Takes N and L0 as inputs. Default is a Bernoulli(0.5) random variable.}

\item{return_data}{Logical. If \code{TRUE} the simulated data is returned.}

\item{beta_L_D_t_prime}{Numeric scalar or NULL. Additional effect of covariate change on death risk after time \code{t_prime} (optional).}

\item{t_prime}{Numeric scalar or NULL. Time point where effects change (optional).}
}
\value{
A list with two components:
\describe{
\item{\code{effect_L}}{Proportion (or years lost) of individuals diagnosed with disease by time \eqn{\tau} in group \code{A0 = a0}, under intervention (\code{G1}) and without intervention (\code{G2}).}
\item{\code{effect_death}}{Proportion (or years lost) of individuals who died by time \eqn{\tau} in group \code{A0 = a0}, under intervention (\code{G1}) and without intervention (\code{G2}).}
}
Or the simulated data.
}
\description{
This function simulates event history data from the Disease setting (see simDisease)
where the shape parameter \eqn{\eta} of the disease process is multiplied by
\code{alpha}. The function either
\itemize{
\item returns the proportion of individuals who experience death and the proportion of individuals who experience disease by a specified time \eqn{\tau} in group \code{A0 = a0}
\item returns number of years lost before \eqn{\tau} of death and disease
\item returns simulated data.
}
}
\examples{
alphaSimDisease(N = 1000, alpha = 0.7, tau = 5, years_lost = FALSE, a0 = 1)
}
