% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_simulation_results.R
\name{calculate_average_outcome}
\alias{calculate_average_outcome}
\title{Summary function for summarize.simulation.results}
\usage{
calculate_average_outcome(res, outcomename, months = 1:54, ...)
}
\arguments{
\item{res}{Dataframe of a single series (simulated or otherwise)}

\item{outcomename}{Name of outcome in res}

\item{months}{Which months to average over, Default: 1:18}

\item{...}{Other parameters (ignored)}
}
\value{
Single number (in this case mean of given months)
}
\description{
Given a set of simulation runs, estimate average impact over range of months.
}
\examples{
data( mecklenberg )
calculate_average_outcome( mecklenberg, "pbail", months=1:24 )
calculate_average_outcome( mecklenberg, "pbail", months = 1:18 )
}
\seealso{
See \code{\link{aggregate_simulation_results}} for how this function would be used.
}
