% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_stutter_exceptions.R
\name{read_stutter_exceptions}
\alias{read_stutter_exceptions}
\title{Reads a stutter exceptions file with overrides for expected stutter ratios}
\usage{
read_stutter_exceptions(filename)
}
\arguments{
\item{filename}{Character. Path to file.}
}
\value{
A named list with the stutter exceptions by locus. For each loucs, the exceptions are given as a named numeric with the names corresponding to the parent alleles and the expected stutter rates given as the values.
}
\description{
Reads a stutter exceptions file with overrides for expected stutter ratios
}
\details{
Reads the file from disk and returns a named numeric vector with stutter ratio exceptions for a given locus and allele.
}
\examples{
filename <- system.file("extdata","GlobalFiler_Stutter_Exceptions_3500.csv",
                        package = "simDNAmixtures")
exceptions <- read_stutter_exceptions(filename)
exceptions$TH01["9.3"]
}
