% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_model.R
\name{drop_model}
\alias{drop_model}
\title{Defines a (semi-continuous) drop model}
\usage{
drop_model(dropout_probabilities, drop_in_rate = 0, freqs, model_settings)
}
\arguments{
\item{dropout_probabilities}{Numeric vector with values between 0 and 1. Dropout probabilities for each contributor.}

\item{drop_in_rate}{Numeric vector of length one. Expected number of drop-ins per locus. Default is 0.}

\item{freqs}{Optionally a list with allele frequencies (needed when drop_in_rate > 0). See \link{read_allele_freqs}.}

\item{model_settings}{List. Possible parameters: \itemize{
\item locus_names. Character vector.
\item size_regression. Function, see \link{read_size_regression}.
}}
}
\value{
Object of class \code{pg_model}.
}
\description{
Defines a (semi-continuous) drop model
}
\details{
Define the classes semi-continuous drop-model. The model may then be used to sample DNA profiles using the \link{sample_mixture_from_genotypes} function. Alternatively, to sample many models and profiles in one go with parameters according to a specified distribution, the \link{sample_mixtures} function can be used.
}
\examples{
gf <- gf_configuration()
freqs <- read_allele_freqs(system.file("extdata","FBI_extended_Cauc_022024.csv",
                                       package = "simDNAmixtures"))
settings <- list(locus_names = gf$autosomal_markers, size_regression = gf$size_regression)

model <- drop_model(dropout_probabilities = c(0.1),
                    drop_in_rate = 1e-3,
                    freqs = freqs, model_settings = settings)

g <- sample_contributor_genotypes(contributors = "U1", freqs = freqs,
                                  loci = settings$locus_names)

# genotype
g

# sample with dropout
sample_mixture_from_genotypes(g, model)
}
\references{
Slooten, K. (2017). Accurate assessment of the weight of evidence for DNA mixtures by integrating the likelihood ratio. Forensic Science International: Genetics, 27, 1-16. \doi{10.1016/j.fsigen.2016.11.001}
}
\seealso{
\link{sample_mixture_from_genotypes}, \link{sample_mixtures}, \link{gamma_model}, \link{log_normal_model}.
}
