% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-stand-density.R
\name{silv_density_sdi}
\alias{silv_density_sdi}
\title{Calculates the Stand Density Index}
\usage{
silv_density_sdi(ntrees, dg, classify = FALSE, max_sdi = NULL)
}
\arguments{
\item{ntrees}{A numeric vector representing the number of trees per hectare}

\item{dg}{A numeric vector of quadratic mean diameters}

\item{classify}{whether to classify the values using USDA thresholds}

\item{max_sdi}{used when \code{classify = TRUE}. The maximum SDi, which depends
on the species, stand type, and site}
}
\value{
A numeric vector
}
\description{
The Stand Density Index (SDI) is relationship between the average tree size and
density of trees per hectare.
}
\details{
The SDI has different interpretation depending on the species, location, and also
the management type (even-aged, uneven-aged...). The value of maximum SDI must
be determined from the literature and used carefully. The option \code{classify = TRUE}
will use this value to classify the SDI in low density (<24\%), moderate density (24-35\%),
high density (34-55\%), and extremely high density (>55\%).
}
\examples{
## calculate SDI for a Pinus sulvestris stand (max 990)
silv_density_sdi(ntrees = 800, dg = 23.4, max_sdi = 990)

## check base classification (other can be used)
silv_density_sdi(ntrees = 800, dg = 23.4, classify = TRUE, max_sdi = 990)
}
