% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigora-package.R
\docType{package}
\name{sigora-package}
\alias{sigora-package}
\alias{_PACKAGE}
\title{sigora: Signature Overrepresentation Analysis}
\description{
Pathway Analysis is statistically linking observations on the molecular level to biological processes or pathways on the systems(i.e., organism, organ, tissue, cell) level. Traditionally, pathway analysis methods regard pathways as collections of single genes and treat all genes in a pathway as equally informative. However, this can lead to identifying spurious pathways as statistically significant since components are often shared amongst pathways. SIGORA seeks to avoid this pitfall by focusing on genes or gene pairs that are (as a combination) specific to a single pathway. In relying on such pathway gene-pair signatures (Pathway-GPS), SIGORA inherently uses the status of other genes in the experimental context to identify the most relevant pathways. The current version allows for pathway analysis of human and mouse datasets. In addition, it contains pre-computed Pathway-GPS data for pathways in the KEGG and Reactome pathway repositories and mechanisms for extracting GPS for user-supplied repositories.
}
\details{
Signature Overrepresentation Analysis

This package implements the pathway analysis method SIGORA. For an in depth
description of the method, please see our manuscript in PeerJ.  In short: a
\emph{GPS} (gene pair signature) is a (weighted) pair of genes that \emph{as
a combination} occurs only in a single pathway within a pathway repository.
A query list is a vector containing a gene list of interest (e.g. genes that
are differentially expressed in a particular condition).  A \emph{present}
GPS is a GPS for which both components are in the query list.  SIGORA
identifies relevant pathways based on the over-representation analysis of
their (present) GPS.

For more details see the package vignette.
}
\references{
Foroushani AB, Brinkman FS and Lynn DJ
(2013).\dQuote{Pathway-GPS and SIGORA: identifying relevant pathways based
on the over-representation of their gene-pair signatures.}\emph{PeerJ},
\bold{1}
}
\seealso{
\code{\link{sigora}}, \code{\link{makeGPS}}, \code{\link{ora}}
}
\author{
Amir B.K. Foroushani, Fiona S.L. Brinkman, David J. Lynn

Maintainer: Witold Wolski <wew@fgcz.ethz.ch>
}
\keyword{internal}
