% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGenes.R
\name{getGenes}
\alias{getGenes}
\title{List genes involved in present GPS for a specific pathway in the
summary_results}
\usage{
getGenes(yy, i, idmap = load_data("idmap"))
}
\arguments{
\item{yy}{A sigora analysis result object (created by \code{sigora}).}

\item{i}{The rank position of the pathway of interest in summary_results.}

\item{idmap}{A dataframe for converting between different gene-identifier
types (e.g. ENSEMBL, ENTREZ and HGNC-Symbols of genes). Most users do not
need to set this argument, as there is a built-in conversion table.}
}
\value{
A table (dataframe) with ids of the relevant genes, ranked by their
contribution to the statistical significance of the pathway.
}
\description{
This function lists the genes involved in the present GPS for a pathway of
interest, odered by their contribution to the significance of the pathway.
}
\examples{

data('kegH')
set.seed(seed=12345)
a1 <- genesFromRandomPathways(kegH,3,50)
## originally selected pathways:\cr
a1[["selectedPathways"]]
## what are the genes
a1[["genes"]]
## sigora's results with this input:\cr
sigoraRes <- sigora(GPSrepo = kegH, queryList = a1[["genes"]],level = 2)
## Genes related to the second most significant result:
head(getGenes(sigoraRes,2))

}
\seealso{
\code{\link{sigora}}
}
\keyword{functions}
