% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsmm_pred.R, R/sighsmm_model.R
\name{hsmm_pred}
\alias{hsmm_pred}
\title{hsmm_pred class}
\description{
A single prediction of \code{signalHsmm}.

A stochastic model of signal peptide produced by \code{signalHsmm}.
}
\details{
Always a named list of five elements
\enumerate{
\item \code{sp_probability} is a probability of signal peptide presence.
\item \code{sp_start} is a start of potential signal peptide (naively 1 aminoacid).
\item \code{sp_end} is a position of last amino acid of signal peptide.
\item \code{struc} is numeric vector representing predicted structure of input 
protein.
\item \code{prot} is character vector containing input sequence of amino acids.
\item \code{str_approx} has value bigger than 0 if the predicted signal peptide 
structure was approximated (usually in case of sequences that have no signal peptides).
}

Always a named list of five elements
\enumerate{
\item \code{aa_group} encoding of amino acids. See \code{\link{aaaggregation}} 
for an example.
\item \code{pipar} probabilities of initial state in Markov Model.
\item \code{tpmpar} matrix of transition probabilities between states.
\item \code{od} matrix of response probabilities. Eg. od[1,2] is a probability 
of signal 2 in state 1.
\item \code{overall_probs_log} probabilities of amino acids in mature protein.
\item \code{params} matrix of probability distribution for duration. Eg. params[10,2] 
is probability of duration of time 10 in state 2.
}
}
\seealso{
\code{\link{summary.hsmm_pred}} \code{\link{plot.hsmm_pred}}

\code{\link{train_hsmm}} \code{\link{predict.sighsmm_model}}
}
