# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Compute most probable path with extended Viterbi algorithm.
#' 
#' Viterbi algorithm for Hidden Markov Model with duration
#' @param aa_sample \code{character} vector representing single aminoacid sequence.
#' @param pipar probabilities of initial state in Markov Model.
#' @param tpmpar matrix of transition probabilities between states.
#' @param od matrix of response probabilities. Eg. od[1,2] is a probability of signal 2 in state 1.
#' @param params matrix of probability distribution for duration. Eg. params[10,2] is probability of duration of time 10 in state 2.
#' @export
#' @return A list of length four:
#' \itemize{
#'  \item{path}{ a vector of most probable path}
#'  \item{viterbi}{ values of probability in all intermediate points,}
#'  \item{psi}{ matrix that gives for every signal and state the previous state in viterbi path,}
#'  \item{duration}{ matrix that gives for every signal and state gives the duration in that state on viterbi path.}
#'  }
#' @note All computations are on logarithms of probabilities.
duration_viterbi <- function(aa_sample, pipar, tpmpar, od, params) {
    .Call('_signalHsmm_duration_viterbi', PACKAGE = 'signalHsmm', aa_sample, pipar, tpmpar, od, params)
}

