% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_group_enrichment.R
\name{show_group_enrichment}
\alias{show_group_enrichment}
\title{Show Group Enrichment Result}
\usage{
show_group_enrichment(
  df_enrich,
  return_list = FALSE,
  scales = "free",
  add_text_annotation = TRUE,
  fill_by_p_value = TRUE,
  use_fdr = TRUE,
  cut_p_value = FALSE,
  cut_breaks = c(-Inf, -5, log10(0.05), -log10(0.05), 5, Inf),
  cut_labels = c("↓ 1e-5", "↓ 0.05", "non-significant", "↑ 0.05", "↑ 1e-5"),
  fill_scale = scale_fill_gradient2(low = "#08A76B", mid = "white", high = "red",
    midpoint = ifelse(fill_by_p_value, 0, 1)),
  cluster_row = FALSE,
  cluster_col = FALSE,
  ...
)
}
\arguments{
\item{df_enrich}{result \code{data.frame} from \link{group_enrichment}.}

\item{return_list}{if \code{TRUE}, return a list of \code{ggplot} object so user
can combine multiple plots by other R packages like \code{patchwork}.}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"},
\code{"free_y"})?}

\item{add_text_annotation}{if \code{TRUE}, add text annotation in box.
When show p value with filled color, the text indicates relative change;
when show relative change with filled color, the text indicates p value.}

\item{fill_by_p_value}{if \code{TRUE}, show log10 based p values with filled color.
The +/- of p values indicates change direction.
If p vlaues is mapped to fill, then text shows effect size, and vice versa.}

\item{use_fdr}{if \code{TRUE}, show FDR values instead of raw p-values.}

\item{cut_p_value}{if \code{TRUE}, cut p values into 5 regions for better visualization.
Only works when \code{fill_by_p_value = TRUE}.}

\item{cut_breaks}{when \code{cut_p_value} is \code{TRUE}, this option set the (log10 based) breaks.}

\item{cut_labels}{when \code{cut_p_value} is \code{TRUE}, this option set the labels.}

\item{fill_scale}{a \code{Scale} object generated by \code{ggplot2} package to
set color for continuous values.}

\item{cluster_row, cluster_col}{if \code{TRUE}, cluster rows (or columns) with Hierarchical Clustering ('complete' method).}

\item{...}{other parameters passing to \link[ggplot2:facet_wrap]{ggplot2::facet_wrap}, only used
when \code{return_list} is \code{FALSE}.}
}
\value{
a (list of) \code{ggplot} object.
}
\description{
See \link{group_enrichment} for examples.
NOTE the box fill and the box text have different meanings.
}
