% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sigProb.r
\name{plot.sigProb}
\alias{plot.sigProb}
\title{Plot predicted probabilities from a \code{sigProb} object.}
\usage{
\method{plot}{sigProb}(x, prob, xvar, main = "", ylab, xlab, col = "blue", pch = 16, ...)
}
\arguments{
\item{x}{an object of class \code{sigProb}, which is obtained by using \code{\link{predict.sigfit}} on a model fit using \code{\link{sigint}}.}

\item{prob}{A string providing the column name for the column of \code{object$predicted} should be used as the outcome or probability of interest.}

\item{xvar}{A string providing the column name of the column (from either object$model or object$par) that provides the "x-variable" in the plot.}

\item{main}{The title of the plot}

\item{ylab}{The y-axis label}

\item{xlab}{The x-axis label}

\item{col}{The color of the plot}

\item{pch}{An integer or character used to choose the type of points used in the plot}

\item{...}{Additional arguments and graphical parameters used by \code{\link{plot}} and \code{\link{par}}}
}
\description{
This method takes a \code{sigProb} object produced by
\code{\link{predict.sigfit}} and plots the comparative static(s) of interest.
}
\examples{
data(sanctionsData)

f1 <- sq+cd+sf+bd ~ sqrt(senderecondep) + senderdemocracy + contig + ally -1|#SA
                    anticipatedsendercosts|#VA
                    sqrt(targetecondep) + anticipatedtargetcosts + contig + ally|#CB
                    sqrt(senderecondep) + senderdemocracy + lncaprat | #barWA
                    targetdemocracy + lncaprat| #barWB
                    senderdemocracy| #bara
                    -1#VB
## Outcome probabilities for first five using NPL probabilities
Phat <- list(PRhat=sanctionsData$PRnpl, PFhat=sanctionsData$PFnpl)
fit2 <- sigint(f1, data=sanctionsData, method="pl", phat=Phat)

## comparative static on \bar{a}, compute more precise equilibria with uniroot
new.theta <- data.frame(t(replicate(25, coef(fit2))))
new.theta[,19] <- seq(-6, 0, length=25)
pout <- predict(fit2, newdata=sanctionsData[93,], new.theta=new.theta, 
                control=list(gridsize=500))


plot(pout, prob="pc", ylab="Pr Challenge", xlab="Audience Costs")



}
\seealso{
\code{\link{predict.sigfit}} \code{\link{generate.eq}} \code{\link{plot}} \code{\link{par}}
}
