% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.eq.r
\name{generate.eq}
\alias{generate.eq}
\title{Equilibrium analysis of the empirical crisis signaling game}
\usage{
generate.eq(
  formulas,
  data,
  theta,
  type = c("actions", "outcomes"),
  na.action = na.omit,
  control = list(),
  parallel = FALSE
)
}
\arguments{
\item{formulas}{a Formula object with no left-hand side and 
seven separate (7) right-hand sides. See "Details" and examples below.}

\item{data}{a data frame containing the variables in the model
Each row of the data frame describes an individual game
\eqn{d = 1, 2, ..., D}. Each row \eqn{d}  should be a summary of all of the
within-game observations for game \eqn{d}.  If the model is all constants, 
then this argument should be left empty.}

\item{theta}{a data frame with one or more rows where each row is a parameter vector.}

\item{type}{whether to provide probabilities over actions 
(default, returns \eqn{p_C}, \eqn{p_R}, and \eqn{p_F}) 
or outcomes (returns \eqn{SQ}, \eqn{CD}, \eqn{SF}, and  \eqn{BD}).}

\item{na.action}{how to deal with \code{NA}s in \code{data}.}

\item{control}{list of options describing the grid search method. See "Details" for more information}

\item{parallel}{logical. Should the comparative statics be computed in parallel, requires the
\code{\link[parallel]{parallel}}
package be installed. Parallelization is done using \code{\link[parallel]{parSapply}}.}
}
\value{
An object of class \code{sigProb} containing three elements:
\describe{
 \item{\code{predicted}}{data frame of predicted probabilities. The first column of this data frame is 
 called \code{Row}, which corresponds to the rows in either \code{model} or \code{par}.
 In the event of multiple equilibria, this column allows for mapping data and parameters to 
 all computed equilibria.
 }
 \item{\code{model}}{data frame of covariates used to produce the predicted probabilities.}
 \item{\code{par}}{data frame of parameters used to produce the predicted probabilities.}
 }
}
\description{
This method uses a formula and fixed data/parameters to allow for analysis 
of the crisis signaling game under specific settings.
This function is very similar to \code{predict.sigfit}, but it is designed 
for analysis outside of conducting counterfactuals on a fitted model.
}
\details{
This function is used to consider comparative statics in the crisis signaling game, where the model
of interest has pre-defined parameters.
As such, it requires, at minimum, a seven-part formula and parameters.
How this function behaves has to do with how \code{data} and \code{theta} are specified.

When the model is all constants (every part of the \code{formula} argument is either \code{0} or \code{1}),
then \code{data} is ignored.
In these cases, equilibria are computed for every parameter vector, which are supplied 
as rows in a data frame to \code{theta}.

When there is one or more covariate in the model, then a data frame must be supplied to \code{data}.
In these cases both \code{data} or \code{theta} must have at least one row.
However, only one of these arguments can have multiple rows.  In other words, only
\code{data} or \code{theta} may vary, but not both.

For additional implementation details see \code{\link{predict.sigfit}}.
}
\examples{
## An example with one covariate
ftest1 <-  ~ 0 | #SA
             1 | #VA
             0 | #CB
             1 | #barWA
             x1 | #barWB
             1| #bara
             1 #VB
             
theta <- data.frame(VA = 1, barWA = -1.9, barWB = -2.9,
                    barWB1 = 0.1, bara = -1.2, VB = 1)
data <- data.frame(x1 = seq(from = -1,to = 2, length.out = 101))
test <- generate.eq(ftest1, data = data, theta = theta)
plot(test, prob = "pr")

## An example with all constants
ftest2 <-  ~ 0 | #SA
             1 | #VA
             0 | #CB
             1 | #barWA
             1 | #barWB  
             1 | #bara
             1 #VB
             
theta <- data.frame(VA = 1, barWA = -1.9, 
                    barWB = seq(-2.9, -2.2, length.out = 15),
                    bara = -1.2,
                    VB = 1)
test <- generate.eq(ftest2, theta = theta)
plot(test, prob = "pr")

}
\seealso{
\code{\link{plot.sigProb}}, \code{\link{predict.sigfit}}
}
