% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrinkTVPVAR_methods.R
\name{LPDS}
\alias{LPDS}
\title{Calculate the log predictive density score (LPDS) for a fitted TVP-VAR-SV model}
\usage{
LPDS(mod, y_true)
}
\arguments{
\item{mod}{an object of class \code{shrinkTVPVAR} or \code{shrinkDTVPVAR}, containing the fitted model.}

\item{y_true}{a numeric vector of length \code{m} containing the true value of the next time-point, i.e. the value at time \code{N + 1}.
The order of the vector has to match the order at time of fitting the model, i.e. the order of the columns in \code{mod$data$Y}.}
}
\value{
A single numeric value containing the log predictive density score (LPDS) for the fitted model evaluated at the true value of the next time-point.
}
\description{
\code{LPDS} calcualtes the one-step ahead log predictive density score (LPDS) for a fitted TVP-VAR-SV model resulting from a call to
\code{shrinkTVPVAR} or \code{shrinkDTVPVAR}. The LPDS is calculated by sampling from the posterior predictive distribution of the model and
evaluating the log predictive density at the true value of the next time-point.
}
\examples{
\donttest{
set.seed(123)
sim <- simTVPVAR(p = 2)
data <- sim$data

train_dat <- data[1:(nrow(data) - 1), ]
test_dat <- data[nrow(data), ]

res <- shrinkTVPVAR(train_dat, p = 2)

LPDS(res, test_dat)

res_dyn <- shrinkDTVPVAR(train_dat, p = 2)

LPDS(res_dyn, test_dat)
}

}
\seealso{
Other prediction functions: 
\code{\link{fitted.shrinkTVPVAR}()},
\code{\link{forecast_shrinkTVPVAR}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{prediction functions}
