% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_shrinkDSM.R
\name{print.shrinkDSM}
\alias{print.shrinkDSM}
\title{Nicer printing of shrinkDSM objects}
\usage{
\method{print}{shrinkDSM}(x, ...)
}
\arguments{
\item{x}{a \code{shrinkDSM} object.}

\item{...}{Currently ignored.}
}
\value{
Called for its side effects and returns invisibly.
}
\description{
Nicer printing of shrinkDSM objects
}
\examples{
\donttest{
set.seed(123)
data("gastric")

# Create intervals for piecewise exponential model
intervals <- divisionpoints(gastric$time, gastric$status, 2)

# Estimate model
mod <- shrinkDSM(time ~ radiation, gastric,
                 delta = gastric$status, S = intervals)

# Print
print(mod)

# Alternatively
mod
}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
