% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tif.R
\name{plot_tif}
\alias{plot_tif}
\title{Plot Test Information Functions}
\usage{
plot_tif(results, tif = c("stf", "full", "both"))
}
\arguments{
\item{results}{The object obtained from the stf-generating functions}

\item{tif}{character, define the TIF to plot, either "stf" (TIF of the STF), "full", (TIF of the full-length test) or "both" (TIF of both STF and full-length test). Default is "stf"}
}
\value{
A ggplot object
}
\description{
Plot the test information functions of the short test form (default), of the full length test or of both versions
}
\examples{
# set a seed to replicate the results
set.seed(999)
# Simulate person and item parameters
true_theta <- rnorm(1000)
b <- runif(30, -3, 3)
a <- runif(30, 0.6, 2)
parameters <- data.frame(b, a)
# simulate data
data <- sirt::sim.raschtype(true_theta, b = b, fixed.a = a)
stf <- uip(data, starting_theta = true_theta, item_par = parameters, num_item = 5)
# plot the test information function of the full-length test
plot_tif(stf, tif = "full")
# plot the test information of the full-length test and of the short test form
plot_tif(stf, tif = "both")
}
