% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{scat_fda_bt}
\alias{scat_fda_bt}
\title{Tuned flexible discriminant analysis results}
\value{
An object with primary class \code{tune_results}.
}
\description{
This object has the results when a flexible discriminant analysis model was
tuned over the interaction degree parameters.
}
\details{
To reduce the object size, five bootstraps were used for resampling
and missing data were removed.

The code used to produce this object:

\if{html}{\out{<div class="sourceCode">}}\preformatted{  library(tidymodels)
  library(discrim)
  tidymodels_prefer()

  # ------------------------------------------------------------------------------

  ctrl_gr <- control_grid(save_pred = TRUE)

  # ------------------------------------------------------------------------------

  data(scat)
  scat <- scat[complete.cases(scat), ]

  # ------------------------------------------------------------------------------

  set.seed(1)
  scat_rs <- bootstraps(scat, times = 5)

  scat_fda_bt <-
    discrim_flexible(prod_degree = tune()) \%>\%
    tune_grid(
      Species ~ .,
      resamples = scat_rs,
      control = ctrl_gr
    )
}\if{html}{\out{</div>}}
}
\keyword{datasets}
