% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{load_runs}
\alias{load_runs}
\title{Create Tidy Load Test Results}
\usage{
load_runs(..., verbose = vroom::vroom_progress())
}
\arguments{
\item{...}{Key-value pairs where the key is the desired name for the test and the
value is a path to the test result directory.}

\item{verbose}{Whether or not to print progress for reading loadtest directories}
}
\value{
A tidy data frame with the test result data. Each row is an event. Columns include identifiers and timing information for the event. The variables are as follows
\describe{
\item{run}{Name of the run}
\item{session_id}{simulated session identifier, 0-based}
\item{user_id}{simulated user identifier, 0-based}
\item{iteration}{user session identifier, 0-based}
\item{input_line_number}{recording line number associated with event}
\item{event}{type of the event}
\item{start}{time the event started, in seconds, relative to the time at which all simulated users were running.}
\item{end}{time the event ended, in seconds, relative to the time at which all simulated users were running}
\item{time}{event duration, in seconds}
\item{concurrency}{number of events that happened at the same time as this one}
\item{maintenance}{whether this event occurred before or after all simulated users were running}
\item{label}{event-specific text label}
\item{json}{raw message JSON and parsed JSON of the event}
}
}
\description{
The \code{shinycannon} tool creates a directory of log files for
each load test. This function translates one or more test result
directories into a tidy data frame.
}
\section{Output variables}{

\itemize{
\item \code{run}: The name of the recording session.
\item \code{session_id}: An incrementing integer value for every session within
a \code{run}. Starts at 0.
\item \code{user_id}: Which simulated user is performing the work within a \code{run}.
Starts at 0.
\item \code{iteration}: an incrementing integer value of the session iteration
for the #' matching \code{user_id}. Starts at 0.
\item \code{input_line_number}: The line number corresponding to the event in the
\code{recording.log} file.
\item \code{event}: the web event being performed. One of the following values:
\itemize{
\item \code{REQ_HOME}: initial request for to load the homepage
\item \code{REQ_GET}: Request a supporting file (JavaScript / CSS)
\item \code{REQ_TOK}: Request a Shiny token
\item \code{REQ_SINF}: Request SockJS information
\item \code{REQ_POST}: Perform a POST query, such as uploading part of a file
\item \code{WS_RECV_BEGIN_UPLOAD}: A file upload is being requested
\item \code{WS_OPEN}: Open a new SockJS connection
\item \code{WS_RECV_INIT}: Initialize a new SockJS
\item \code{WS_SEND}: Send information from the Shiny server to the browser
\item \code{WS_RECV}: Send information from the browser to the Shiny server
\item \code{WS_CLOSE}: Close the SockJS connection
}
\item \code{start}: Start time of the event relative to the beginning of the \code{run}'s
maintenance period
\item \code{end}: End time of the event relative to the beginning of the \code{run}'s
maintenance period
\item \code{time}: Total elapsed time of the event
\item \code{concurrency}: A number of events that are being processed concurrently
\item \code{maintenance}: A boolean determining whether or not all simulated users
are executing a session
\item \code{label}: A human readable event name
\item \code{json}: The parsed JSON provided in the \code{recording.log} file. If the field
\code{message} exists, a \code{message_parsed} field is added containing a parsed
form of the SockJS's JSON message content.
}
}

\examples{
\dontrun{
load_runs(
  `1 core` = "results/run-1/",
  `2 cores` = "results/run-2/"
)
}
}
