% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardHeader.R
\name{taskItem}
\alias{taskItem}
\title{Custom taskItem}
\usage{
taskItem(text, value = 0, color = "aqua", href = NULL, inputId = NULL)
}
\arguments{
\item{text}{The task text.}

\item{value}{A percent value to use for the bar.}

\item{color}{A color for the bar. Valid colors are listed in
\link[shinydashboard]{validColors}.}

\item{href}{An optional URL to link to.}

\item{inputId}{If not NULL, this item behaves like an action button.}
}
\description{
Custom taskItem
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinydashboard)
  library(shinydashboardPlus)

  shinyApp(
    ui = dashboardPage(
      dashboardHeader(
        dropdownMenu(
          type = "tasks",
          badgeStatus = "danger",
          taskItem(
            inputId = "mytask",
            value = 20,
            color = "aqua",
            text = "Click me!"
          ),
          taskItem(
            value = 40,
            color = "green",
            text = "Basic item"
          )
        )
      ),
      dashboardSidebar(),
      dashboardBody(),
      title = "Dashboard example"
    ),
    server = function(input, output) {
      observeEvent(input$mytask, {
        showModal(modalDialog(
          title = "Important message",
          "This is an important message!"
        ))
      })
    }
  )
}
}
