% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slim-select.R
\name{prepare_slim_choices}
\alias{prepare_slim_choices}
\title{Prepare choices for \code{\link[=slimSelectInput]{slimSelectInput()}}}
\usage{
prepare_slim_choices(
  .data,
  label,
  value,
  html = NULL,
  selected = NULL,
  display = NULL,
  disabled = NULL,
  mandatory = NULL,
  class = NULL,
  style = NULL,
  .by = NULL,
  selectAll = NULL,
  closable = NULL
)
}
\arguments{
\item{.data}{An object of type \code{\link[=data.frame]{data.frame()}}.}

\item{label}{Variable to use as labels (displayed to user).}

\item{value}{Variable to use as values (retrieved server-side).}

\item{html}{Alternative HTML to be displayed instaed of label.}

\item{selected}{Is the option must be selected ?}

\item{display}{Allows to hide elements of selected values.}

\item{disabled}{Allows the ability to disable the select dropdown as well as individual options.}

\item{mandatory}{When using multi select you can set a mandatory on the option to prevent capability
to deselect particular option. Note options with mandatory flag is not selected by default, you need select them yourselfs.}

\item{class}{Add CSS classes.}

\item{style}{Add custom styles to options.}

\item{.by}{Variable identifying groups to use option group feature.}

\item{selectAll}{Enable select all feature for options groups.}

\item{closable}{Allow to close options groups, one of: 'off', 'open', 'close'.}
}
\value{
A \code{list} to use as \code{choices} argument of \code{\link[=slimSelectInput]{slimSelectInput()}}.
}
\description{
Prepare choices for \code{\link[=slimSelectInput]{slimSelectInput()}}
}
\examples{

library(shiny)
library(shinyWidgets)

state_data <- data.frame(
  name = state.name,
  abb = state.abb,
  region = state.region,
  division = state.division
)

ui <- fluidPage(
  tags$h2("Slim Select examples"),
  fluidRow(
    column(
      width = 3,
      slimSelectInput(
        inputId = "slim1",
        label = "Disable some choices:",
        choices = prepare_slim_choices(
          state_data,
          label = name,
          value = abb,
          disabled = division == "Mountain"
        ),
        width = "100\%"
      ),
      verbatimTextOutput("res1")
    ),
    column(
      width = 3,
      slimSelectInput(
        inputId = "slim2",
        label = "Custom styles:",
        choices = prepare_slim_choices(
          state_data,
          label = name,
          value = abb,
          style = ifelse(
            division == "Mountain",
            "color: blue;",
            "color: red;"
          )
        ),
        multiple = TRUE,
        placeholder = "Select a state",
        width = "100\%"
      ),
      verbatimTextOutput("res2")
    ),
    column(
      width = 3,
      slimSelectInput(
        inputId = "slim3",
        label = "Options groups with options:",
        choices = prepare_slim_choices(
          state_data,
          label = name,
          value = abb,
          .by = region,
          selectAll = TRUE,
          closable = "close"
        ),
        multiple = TRUE,
        width = "100\%"
      ),
      verbatimTextOutput("res3")
    )
  )
)

server <- function(input, output, session) {
  output$res1 <- renderPrint(input$slim1)

  output$res2 <- renderPrint(input$slim2)

  output$res3 <- renderPrint(input$slim3)
}

if (interactive())
  shinyApp(ui, server)
}
