% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/inputs.R
\name{slider}
\alias{slider}
\alias{slider_input}
\alias{update_slider_input}
\title{slider}
\usage{
slider_input(inputId, ..., value = default_value)

update_slider_input(session = shiny::getDefaultReactiveDomain(), inputId, ...)
}
\arguments{
\item{inputId}{ID of the component.}

\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI slider component.
}
\description{
A slider allows a user to select one or more values within a range.
}
\details{
\itemize{
\item \bold{label}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{name}. Type: \code{string}. Default: \code{NA}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{color}. Type: \code{foreground OR primary OR secondary OR success OR warning OR danger}. Default: \code{"primary"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg OR full}. Default: \code{"full"}.
\item \bold{step}. Type: \code{number}. Default: \code{"1"}.
\item \bold{value}. Type: \code{number}. Default: \code{NA}.
\item \bold{defaultValue}. Type: \code{number}. Default: \code{NA}.
\item \bold{minValue}. Type: \code{number}. Default: \code{"0"}.
\item \bold{maxValue}. Type: \code{number}. Default: \code{"100"}.
\item \bold{orientation}. Type: \code{horizontal OR vertical}. Default: \code{"horizontal"}.
\item \bold{fillOffset}. Type: \code{number}. Default: \code{NA}.
\item \bold{showSteps}. Type: \code{boolean}. Default: \code{false}.
\item \bold{showTooltip}. Type: \code{boolean}. Default: \code{false}.
\item \bold{marks}. Type: \code{SliderStepMarks}. Default: \code{NA}.
\item \bold{startContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{endContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{formatOptions}. Type: \code{Intl.NumberFormat}. Default: \code{NA}.
\item \bold{tooltipValueFormatOptions}. Type: \code{Intl.NumberFormat}. Default: \code{NA}.
\item \bold{tooltipProps}. Type: \code{TooltipProps}. Default: \code{NA}.
\item \bold{showOutline}. Type: \code{boolean}. Default: \code{false}.
\item \bold{hideValue}. Type: \code{boolean}. Default: \code{false}.
\item \bold{hideThumb}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableThumbScale}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
}
\itemize{
\item \bold{getValue}. Type: \code{(value: SliderValue) => string}. Default: \code{NA}.
\item \bold{renderLabel}. Type: \code{(props: DOMAttributes<HTMLLabelElement>) => ReactNode}. Default: \code{NA}.
\item \bold{renderValue}. Type: \code{(props: DOMAttributes<HTMLOutputElement>) => ReactNode}. Default: \code{NA}.
\item \bold{renderThumb}. Type: \code{(props: DOMAttributes<HTMLDivElement> & {index?: number}) => ReactNode}. Default: \code{NA}.
}
\itemize{
\item \bold{onChange}. Type: \code{(value: SliderValue) => void}. Default: \code{NA}.
\item \bold{onChangeEnd}. Type: \code{(value: SliderValue) => void}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  debug_react = TRUE,
  action_button("update", "Update slider 1"),
  slider_input(
    "slider",
    label = "My slider",
    showTooltip = TRUE,
    radius = "none",
    step = 1,
    maxValue = 10,
    minValue = 0,
    value = 5,
    className = "max-w-md",
    showSteps = TRUE,
    color = "foreground",
    size = "sm",
    marks = JS(
      "
      [
        {
          value: 2,
          label: 'First mark',
        },
        {
          value: 5,
          label: 'Second mark',
        },
        {
          value: 8,
          label: 'Third mark',
        },
      ]
    "
    )
  ),
  spacer(y = 10),
  slider_input(
    "slider2",
    radius = "lg",
    label = "Color offset",
    size = "sm",
    showTooltip = TRUE,
    color = "warning",
    maxValue = 5,
    minValue = -5,
    fillOffset = 0,
    value = 1,
    formatOptions = JS("{signDisplay: 'always'}")
  ),
  spacer(y = 10),
  slider_input(
    "slider3",
    label = "Outline",
    color = "foreground",
    showOutline = TRUE,
    minValue = 0,
    maxValue = 10,
    value = 5
  ),
  spacer(y = 10),
  slider_input(
    "slider4",
    label = "With start and end content",
    minValue = 0,
    maxValue = 10,
    value = 5,
    startContent = icon("volume-xmark"),
    endContent = icon("volume-high")
  ),
  spacer(y = 10),
  slider_input(
    "slider5",
    color = "success",
    step = 0.1,
    label = "Format value with getValue",
    getValue = JS("(val) => `${val} / 10`"),
    maxValue = 10,
    minValue = 0,
    value = 5
  ),
  spacer(y = 10),
  slider_input(
    "range",
    label = "Range",
    color = "danger",
    minValue = 0,
    maxValue = 10,
    value = c(1, 4)
  ),
  spacer(y = 10),
  div(
    class = "flex flex-row  max-w-md h-[348px] gap-6 w-full",
    slider_input(
      "slider4",
      label = "Vertical",
      size = "sm",
      orientation = "vertical",
      minValue = 0,
      maxValue = 10,
      value = 5,
      startContent = icon("volume-high"),
      endContent = icon("volume-xmark")
    )
  )
)

server <- function(input, output, session) {
  observeEvent(input$update, {
    update_slider_input(session, inputId = "slider", value = 10)
  })

  observeEvent(input$slider, {
    print(class(input$slider))
    print(sprintf("Slider is: \%s", input$slider))
  })
  observeEvent(input$range, {
    print(input$range)
  })
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/slider}.
}
