% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_tailwind.R
\name{use_tailwind}
\alias{use_tailwind}
\title{'TailwindCSS' with Shiny}
\usage{
use_tailwind(css = NULL, tailwindConfig = NULL)
}
\arguments{
\item{css}{Optional. Path to ".css" file. Can use @apply tags for applying
Tailwind classes. See description for more details.}

\item{tailwindConfig}{Optional. Path to ".js" file containing json object
\code{tailwind.config = {}}. See
\url{https://github.com/tailwindlabs/tailwindcss/releases/tag/v3.0.0-alpha.1}.}
}
\value{
a list of type \code{shiny.tag} with head and script elements needed to
run a tailwind app
}
\description{
'TailwindCSS' with Shiny
}
\details{
'TailwindCSS' is a utility-based design framework that makes designing simple.
See details in the README for this package for why this is so great.

However, the complete set of tailwind css classes is massive (~15mb), so
you don't want to load all of these. That is where Tailwind's new Just in
Time compiling comes in. It will only load the css classes you use, as you
use them. So if your shiny app renders ui dynamically, it will load
appropriate css whenever the UI is rendered.

Custom css can use the \verb{@apply} directives that come with tailwind to easily
compile set of classes. See
\url{https://tailwindcss.com/docs/functions-and-directives#apply} for
more details. It just \emph{has} to be passed to the use_tailwind function if you
want to use the \verb{@apply} directive.

Custom configuration of tailwind is also possible. There are two options
available in \code{use_tailwind}. First, if you don't want to use any custom
modules, uses tailwindConfig. An example is in the folder
\code{inst/examples/02-config} in the github repository. Note the \code{.js} file should
only consist of the creation of the JSON object \code{tailwind.config = {}}.
The function will place it in the appropriate script tag.
}
\examples{
library(shiny)
example_apps <- list.files(system.file("examples", package = "shiny.tailwind"),
  full.names = TRUE
)
basename(example_apps)

if (interactive()) runApp(example_apps[1])
}
