% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R
\name{Announced}
\alias{Announced}
\title{Announced}
\usage{
Announced(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
The Announced component aims to fill several of the accessibility gaps that exist in various web application experiences.
It provides text for the screen reader in certain scenarios that are lacking comprehensive updates, particularly those showing
the completion status or progress of operation(s).

Some real-world applications of the component include copying, uploading, or moving many files; deleting or renaming a single file;
"lazy loading" of page sections that do not appear all at once; and appearance of search results.

The Announced component currently has the following documented use cases:
\enumerate{
\item \href{#/controls/web/announced/quickactions}{Quick Actions}: Operations such as editing text or deletion that are short enough that they do not require a status during progress.
\item \href{#/controls/web/announced/searchresults}{Search Results}: Appearance of search results such as in contact fields or search boxes.
\item \href{#/controls/web/announced/lazyloading}{Lazy Loading}: "Lazy loading" of page sections that do not appear all at once.
\item \href{#/controls/web/announced/bulkoperations}{Bulk Operations}: Operations that require multiple sub operations, such as the moving of several files.
}

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Announced}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item \bold{ "aria-live" } \code{'off' | 'polite' | 'assertive'} \cr Priority with which the screen reader should treat updates to this region  @default 'polite'
\item \bold{ as } \code{React.ElementType} \cr Optionally render the root of this component as another component type or primitive. The custom type \strong{must} preserve any children or native props passed in.  @default 'div'
\item \bold{ message } \code{string} \cr The status message provided as screen reader output
\item \bold{ styles } \verb{IStyleFunctionOrObject<\{\}, IAnnouncedStyles>} \cr Call to provide customized styling that will layer on top of the variant rules.
}
}
\examples{
library(shiny)
library(shiny.fluent)

ui <- function(id) {
  Announced(message = "Screen reader message")
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {})
}

if (interactive()) {
  shinyApp(ui("app"), function(input, output) server("app"))
}
}
