#' Characteristics of phase in XRF map of oyster
#'
#' A dataset containing trace element concentrations and RGB colour values
#' of a phase map of the XRF mapped surface of the Crassostrea gigas #1 oyster
#' used as an example in de Winter (2017)
#'
#' @docType data
#'
#' @usage data(O1_phase)
#'
#' @format A data frame with 5 rows and 30 variables:
#'
#' \describe{
#'   \item{Description}{Desription of phase}
#'   \item{Name}{Name of phase}
#'   \item{R}{R-value of phase colour}
#'   \item{G}{G-value of phase colour}
#'   \item{B}{B-value of phase colour}
#'   \item{density}{specific density of different phases}
#'   \item{C}{Concentration of C in phase}
#'   \item{O}{Concentration of O in phase}
#'   \item{Na}{Concentration of Na in phase}
#'   \item{Mg}{Concentration of Mg in phase}
#'   \item{Al}{Concentration of Al in phase}
#'   \item{Si}{Concentration of Si in phase}
#'   \item{P}{Concentration of P in phase}
#'   \item{S}{Concentration of S in phase}
#'   \item{Cl}{Concentration of Cl in phase}
#'   \item{K}{Concentration of K in phase}
#'   \item{Ca}{Concentration of Ca in phase}
#'   \item{Ti}{Concentration of Ti in phase}
#'   \item{Cr}{Concentration of Cr in phase}
#'   \item{Mn}{Concentration of Mn in phase}
#'   \item{Fe}{Concentration of Fe in phase}
#'   \item{Ni}{Concentration of Ni in phase}
#'   \item{Cu}{Concentration of Cu in phase}
#'   \item{Zn}{Concentration of Zn in phase}
#'   \item{Br}{Concentration of Br in phase}
#'   \item{Rb}{Concentration of Rb in phase}
#'   \item{Sr}{Concentration of Sr in phase}
#'   \item{Rh}{Concentration of Rh in phase}
#'   \item{Ba}{Concentration of Ba in phase}
#'   \item{Pb}{Concentration of Pb in phase}
#' }
#' @source \url{https://doi.org/10.5194/gmd-2017-137-supplement}
"O1_phase"
