#' Matrix of modelled cumulative mass accumulation rates per trace element
#'
#' A dataset containing mass accumulation of trace elements modelled for every
#' based on the a phase map of the XRF mapped surface of the Crassostrea
#' gigas #1 oyster used as an example in de Winter (2017)
#'
#' @docType data
#'
#' @usage data(M_el_mat_c)
#'
#' @format A data frame with 5 rows and 24 variables:
#'
#' \describe{
#'   \item{C}{Cumulative mass accumulation of C in subincrement}
#'   \item{O}{Cumulative mass accumulation of O in subincrement}
#'   \item{Na}{Cumulative mass accumulation of Na in subincrement}
#'   \item{Mg}{Cumulative mass accumulation of Mg in subincrement}
#'   \item{Al}{Cumulative mass accumulation of Al in subincrement}
#'   \item{Si}{Cumulative mass accumulation of Si in subincrement}
#'   \item{P}{Cumulative mass accumulation of P in subincrement}
#'   \item{S}{Cumulative mass accumulation of S in subincrement}
#'   \item{Cl}{Cumulative mass accumulation of Cl in subincrement}
#'   \item{K}{Cumulative mass accumulation of K in subincrement}
#'   \item{Ca}{Cumulative mass accumulation of Ca in subincrement}
#'   \item{Ti}{Cumulative mass accumulation of Ti in subincrement}
#'   \item{Cr}{Cumulative mass accumulation of Cr in subincrement}
#'   \item{Mn}{Cumulative mass accumulation of Mn in subincrement}
#'   \item{Fe}{Cumulative mass accumulation of Fe in subincrement}
#'   \item{Ni}{Cumulative mass accumulation of Ni in subincrement}
#'   \item{Cu}{Cumulative mass accumulation of Cu in subincrement}
#'   \item{Zn}{Cumulative mass accumulation of Zn in subincrement}
#'   \item{Br}{Cumulative mass accumulation of Br in subincrement}
#'   \item{Rb}{Cumulative mass accumulation of Rb in subincrement}
#'   \item{Sr}{Cumulative mass accumulation of Sr in subincrement}
#'   \item{Rh}{Cumulative mass accumulation of Rh in subincrement}
#'   \item{Ba}{Cumulative mass accumulation of Ba in subincrement}
#'   \item{Pb}{Cumulative mass accumulation of Pb in subincrement}
#' }
#' @source \url{https://doi.org/10.5194/gmd-2017-137-supplement}
"M_el_mat_c"
