#' @export
#' @import stats
rlse_gamma <- function(p, alpha, beta) {
    SE <- function(p, alpha, beta) {
        fn = function(x) {
            (stats::dgamma(x,alpha, beta)) * ((stats::dgamma(x,alpha, beta, log = TRUE)) - log(stats::pgamma(p[i],
                alpha, beta)))
        }
        ES = p
        for (i in 1:length(p)) {
            ES[i] = (stats::integrate(fn, lower = 0, upper = p[i], stop.on.error = FALSE)$value)
        }
        return(ES)
    }
    sinc <- -1 * (1/stats::pgamma(p, alpha, beta)) * SE(p, alpha, beta)
    ((Se_gamma(alpha, beta) - sinc))/(Se_gamma(alpha, beta))
}

#' @export
rlre_gamma <- function(p, alpha, beta, delta) {
    RE <- function(p, alpha, beta, delta) {
        fn = function(x) {
            (stats::dgamma(x, alpha, beta))^delta
        }
        ES = p
        for (i in 1:length(p)) {
            ES[i] = (stats::integrate(fn, lower = 0, upper = p[i], stop.on.error = FALSE)$value)
        }
        return(ES)
    }

    rinc <- (1/(1 - delta)) * log((1/stats::pgamma(p, alpha, beta))^delta * RE(p,
        alpha, beta, delta))

    (re_gamma(alpha, beta, delta) - rinc)/re_gamma(alpha, beta, delta)
}

#' @export
rlhce_gamma <- function(p, alpha, beta, delta) {
    HC <- function(p, alpha, beta, delta) {
        fn = function(x) {
            (stats::dgamma(x, alpha, beta))^delta
        }
        ES = p
        for (i in 1:length(p)) {
            ES[i] = (stats::integrate(fn, lower = 0, upper = p[i], stop.on.error = FALSE)$value)
        }
        return(ES)
    }
    hcinc <- (1/(2^(1 - delta) - 1)) * (((1/stats::pgamma(p, alpha, beta))^delta *
        HC(p, alpha, beta, delta)) - 1)
    (hce_gamma(alpha, beta, delta) - hcinc)/hce_gamma(alpha, beta, delta)
}

#' @export
rlae_gamma <- function(p, alpha, beta, delta) {
    AE <- function(p, alpha, beta, delta) {
        fn = function(x) {
            (stats::dgamma(x, alpha, beta))^delta
        }
        ES = p
        for (i in 1:length(p)) {
            ES[i] = (stats::integrate(fn, lower = 0, upper = p[i], stop.on.error = FALSE)$value)
        }
        return(ES)
    }
    ainc <- (delta/(1 - delta)) * (((1/stats::pgamma(p, alpha, beta))^delta * AE(p,
        alpha, beta, delta))^(1/delta) - 1)

    (ae_gamma(alpha, beta, delta) - ainc)/ae_gamma(alpha, beta, delta)
}
