% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_calculation.R
\name{step_metrics}
\alias{step_metrics}
\title{Calculates step metrics including distance, dt, dx, and dy.}
\usage{
step_metrics(sftraj)
}
\arguments{
\item{sftraj}{an sftrack/sftraj object. sftrack objects will be converted to sftraj internally for calculation.}
}
\description{
Calculates step metrics including distance, dt, dx, and dy.
}
\examples{
#'
data("raccoon")
raccoon$timestamp <- as.POSIXct(raccoon$timestamp, "EST")
burstz <- list(id = raccoon$animal_id, month = as.POSIXlt(raccoon$timestamp)$mon)
# Input is a data.frame
my_sftraj <- as_sftraj(raccoon,
  group = burstz, time = "timestamp",
  error = NA, coords = c("longitude", "latitude")
)

step_metrics(my_sftraj)[1:10, ]
}
