% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sffdr.R
\name{sffdr}
\alias{sffdr}
\title{Surrogate Functional False Discovery Rate Analysis}
\usage{
sffdr(
  p.value,
  fpi0,
  surrogate = NULL,
  epsilon = .Machine$double.xmin,
  nn = NULL,
  fp_ties = TRUE,
  seed = 2026,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{p.value}{Numeric vector of p-values to analyze.}

\item{fpi0}{Numeric vector of functional pi0 estimates, obtained
from \code{\link{fpi0est}}. Values must be in [0, 1].}

\item{surrogate}{Optional numeric vector (same length as \code{p.value}) used
as a surrogate variable for compression. If NULL (default), uses
\code{fpi0} as the surrogate.}

\item{epsilon}{Numeric; lower bound for p-value clamping during density estimation.
Default is \code{.Machine$double.xmin}.}

\item{nn}{Numeric; nearest-neighbor bandwidth for \code{\link{kernelEstimator}}.
If NULL (default), automatically selected as ~5000 neighbors.}

\item{fp_ties}{Logical; whether to break ties in functional p-values using the
original p-value ordering. Default is TRUE.}

\item{seed}{Integer; random seed for reproducibility of rank tie-breaking.
Default is 2026.}

\item{verbose}{Logical; print progress messages. Default is TRUE.}

\item{...}{Additional arguments passed to \code{\link{kernelEstimator}}.}
}
\value{
An S3 object of class \code{"sffdr"} containing:
\item{call}{The function call.}
\item{pvalues}{Original p-values.}
\item{fpvalues}{Functional p-values.}
\item{fqvalues}{Functional q-values.}
\item{flfdr}{Functional local false discovery rates.}
\item{fpi0}{Functional pi0 estimates.}
\item{fx}{Joint density estimates at observed (p-value, surrogate) pairs.}
}
\description{
Estimate functional p-values, q-values, and local false discovery rates (lfdr)
for GWAS data leveraging summary statistics from related traits. Functional p-values map from the
functional q-value (FDR-based measure) to a p-value for type I error rate control,
accounting for pleiotropy that impacts the prior probability of
association.
}
\details{
The surrogate functional FDR (sfFDR) methodology extends the functional FDR
framework to leverage multiple informative variables (e.g., functional annotations,
GWAS summary statistics) for increased power while controlling
false discovery rates.

Workflow:

\enumerate{
  \item Estimate functional pi0 (proportion of nulls) using \code{\link{fpi0est}}
  \item Call \code{sffdr()} with p-values and estimated functional pi0
  \item Use returned functional p-values/q-values/local FDRs for significance testing
}

Surrogate Variable:
If not specified, the estimated functional pi0 is used as the surrogate variable.
}
\examples{
# Import data
data(bmi)

# Separate main p-values and conditioning p-values
p <- sumstats$bmi
z <- as.matrix(sumstats[, -1])

# Apply pi0_model to create model
# (note: use indep_snps argument to specify independent SNPs for training)
fmod <- pi0_model(z)

# Estimate functional pi0
# (note: use indep_snps argument to specify independent SNPs for training)
fpi0_out <- fpi0est(p, fmod)
fpi0 <- fpi0_out$fpi0

# Apply sffdr
sffdr_out <- sffdr(p, fpi0)

# Plot significance results
plot(sffdr_out)

# Extract functional quantities
fp <- sffdr_out$fpvalues
fq <- sffdr_out$fqvalues
flfdr <- sffdr_out$flfdr

}
\seealso{
\code{\link{fpi0est}}, \code{\link{plot.sffdr}}, \code{\link{kernelEstimator}}
}
\author{
Andrew J. Bass
}
\keyword{sffdr}
