% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_apply.R
\name{sfc_apply,sfc_nxn-method}
\alias{sfc_apply,sfc_nxn-method}
\alias{sfc_apply}
\title{Apply to every unit in the sfc_nxn curve}
\usage{
\S4method{sfc_apply}{sfc_nxn}(p, depth = 1, fun = function(x) x)
}
\arguments{
\item{p}{An \code{sfc_nxn} object.}

\item{depth}{An integer between 0 and \code{level-1} of the curve.}

\item{fun}{A function of which the argument \code{x} is a subunit in the curve. The subunit is an \code{sfc_nxn} object but only contains the current sub-sequence.
The function should return an \code{sfc_seuqence} object with the same length as of \code{x}. The function can take an optional second argument which
the index of the current subunit in the curve.}
}
\value{
An \code{sfc_nxn} object.
}
\description{
Apply to every unit in the sfc_nxn curve
}
\details{
This function is mainly used to flip subunits on various levels on the curve, thus mainly on the Peano curve and the Meander curve.
A depth of 0 corresponds to the complete curve. A depth of 1 corresponds to the nine first-level units, et al.

Currently, \code{sfc_apply()} only works on curves with a single base pattern as the seed.
}
\examples{
p = sfc_3x3_peano("I", level = 3)
# flip the global curve
draw_multiple_curves(
    p, 
    sfc_apply(p, 0, sfc_flip_unit),
    nrow = 1
)

# flip all the subunits on depth = 1
draw_multiple_curves(
    p, 
    sfc_apply(p, 1, sfc_flip_unit),
    nrow = 1
)

# flip all the subunits on depth = 2
draw_multiple_curves(
    p, 
    sfc_apply(p, 2, sfc_flip_unit),
    nrow = 1
)

# flip all level-1 patterns on the Peano curve to horizontal
# only works on the lowest subunit, 
p2 = sfc_apply(p, 2, function(x) {
    if(level1_unit_orientation(x) == "vertical") {
        sfc_flip_unit(x)
    } else {
        x
    }
})
# then on depth=1, only flip the unit with odd index
p3 = sfc_apply(p2, 1, function(x, i) {
    if(i \%\% 2 == 1) {
        sfc_flip_unit(x)
    } else {
        x
    }
})
draw_multiple_curves(p2, p3, nrow = 1)

# flip all level-1 patterns to vertical
p3 = sfc_apply(p, 2, function(x) {
    if(level1_unit_orientation(x) == "horizontal") {
        sfc_flip_unit(x)
    } else {
        x
    }
})
draw_multiple_curves(p, p3, nrow = 1)
}
