% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{draw_multiple_curves}
\alias{draw_multiple_curves}
\title{Draw multiple curves}
\usage{
draw_multiple_curves(
  ...,
  list = NULL,
  nrow = NULL,
  ncol = NULL,
  extend = TRUE,
  title = FALSE,
  closed = FALSE,
  padding = unit(0, "pt"),
  lwd = 4,
  col = NULL
)
}
\arguments{
\item{...}{A list of \code{sfc_sequence} objects or objects in its child classes, a list of \code{\link[grid:grid.grob]{grid::grob}} objects
or a list of two-column coordinate matrices, i.e., all the forms that can represent curves in this package.}

\item{list}{The list of curve object can also be directly specified as a "list" object.}

\item{nrow}{Number of rows in the layout.}

\item{ncol}{Number of columns in the layout.}

\item{extend}{Whether to draw the entry and exit segments? It is only used when input is a list of \code{sfc_sequence} objects.}

\item{title}{Whether to add titles on each panel? The title is constructed in the form of \code{initial_seed|expansion_codes}, e.g. \code{I|111}.
The value can be a vector of user-defined strings.}

\item{closed}{Whether the curves are closed? The value should be a logical vector. If it is \code{TRUE}, the last point
is connected to the first point in the curve to form a closed curve. Length of \code{closed} can be 1 or the number of curves.}

\item{padding}{Space around each curve. The value should be a \code{\link[grid:unit]{grid::unit}} object with length 1.}

\item{lwd}{Line width with length 1.}

\item{col}{Color for the segments with length 1. If the value is \code{NULL}, it uses the "Spectral" color palettes from the \strong{RColorBrewer} package.}
}
\value{
No value is returned.
}
\description{
Draw multiple curves
}
\details{
This function is used for quick comparison on curves.
}
\examples{
# for all forms of curves initialized by base pattern 'R', with rotation 0, and on level 3
draw_multiple_curves(
    sfc_2x2("R", "111"),
    sfc_2x2("R", "112"),
    sfc_2x2("R", "121"),
    sfc_2x2("R", "122"),
    sfc_2x2("R", "211"),
    sfc_2x2("R", "212"),
    sfc_2x2("R", "221"),
    sfc_2x2("R", "222"),
    nrow = 2, title = TRUE)

# simply a list of sequences
# note they only contain I/R/L, so the base patterns I/R/L are internally used
draw_multiple_curves(
    sfc_sequence("IIII"),
    sfc_sequence("RRRR"),
    sfc_sequence("RRLL"),
    nrow = 1
)
}
