% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_stan_data.R
\name{build_stan_data}
\alias{build_stan_data}
\title{Builds stan data for sampling depending on the selected model}
\usage{
build_stan_data(
  serosurvey,
  model_type = "constant",
  foi_prior = sf_uniform(),
  foi_index = NULL,
  is_log_foi = FALSE,
  foi_sigma_rw = sf_none(),
  is_seroreversion = FALSE,
  seroreversion_prior = sf_none()
)
}
\arguments{
\item{serosurvey}{\describe{
\item{\code{survey_year}}{Year in which the survey took place
(only needed to plot time models)}
\item{\code{age_min}}{Floor value of the average between age_min and age_max}
\item{\code{age_max}}{The size of the sample}
\item{\code{n_sample}}{Number of samples for each age group}
\item{\code{n_seropositive}}{Number of positive samples for each age group}
}}

\item{model_type}{Type of the model. Either "constant", "age" or "time"}

\item{foi_prior}{Force-of-infection distribution specified by means of
the helper functions. Currently available options are:
\describe{
\item{\link{sf_normal}}{Function to set normal distribution priors}
\item{\link{sf_uniform}}{Function to set uniform distribution priors}
}}

\item{foi_index}{Integer vector specifying the age-groups for which
Force-of-Infection values will be estimated. It can be specified by
means of \link{get_foi_index}}

\item{is_log_foi}{Boolean to set logarithmic scale in the FoI}

\item{foi_sigma_rw}{Prior distribution for the standard deviation of the
Force-of-Infection. Currently available options are:
\describe{
\item{\link{sf_normal}}{Function to set normal distribution prior.
Available for time models in the log-scale}
\item{\link{sf_cauchy}}{Function to set Cauchy distribution prior.
Available for time models in regular scale.}
}}

\item{is_seroreversion}{Boolean specifying whether to include
seroreversion rate estimation in the model}

\item{seroreversion_prior}{seroreversion distribution specified by means of
the helper functions. Currently available options are:
\describe{
\item{\link{sf_normal}}{Function to set normal distribution priors}
\item{\link{sf_uniform}}{Function to set uniform distribution priors}
\item{\link{sf_none}}{Function to set no prior distribution}
}}
}
\value{
List with necessary data for sampling the specified model
}
\description{
Builds stan data for sampling depending on the selected model
}
