% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.pop_data.R
\name{autoplot.pop_data}
\alias{autoplot.pop_data}
\title{Plot distribution of antibodies}
\usage{
\method{autoplot}{pop_data}(object, log = FALSE, type = "density", strata = NULL, ...)
}
\arguments{
\item{object}{A \code{pop_data} object (from \code{\link[=load_pop_data]{load_pop_data()}})}

\item{log}{whether to show antibody responses on logarithmic scale}

\item{type}{an option to choose type of chart:
the current options are \code{"density"} or \code{"age-scatter"}}

\item{strata}{the name of a variable in \code{pop_data}
to stratify by (or \code{NULL} for no stratification)}

\item{...}{unused}
}
\value{
a \link[ggplot2:ggplot]{ggplot2::ggplot} object
}
\description{
\code{autoplot()} method for \code{pop_data} objects
}
\examples{
\donttest{
library(dplyr)
library(ggplot2)
library(magrittr)

xs_data <-
  serocalculator_example("example_pop_data.csv") |>
  read.csv() |>
  as_pop_data()

xs_data |> autoplot(strata = "catchment", type = "density")
xs_data |> autoplot(strata = "catchment", type = "age-scatter")
}
}
