% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rice_moore}
\alias{rice_moore}
\title{Rice and Moore's method}
\usage{
rice_moore(s, n, alpha, MonteCarlo, f.star = 1.5 - min(n) + 0.5 * sqrt((3 - 2
  * min(n))^2 - 4 * (min(n) - 1) * log(alpha) * qchisq(p = alpha, df = 2)), ...)
}
\arguments{
\item{s}{Vector of successes.}

\item{n}{Vector of sample sizes.}

\item{alpha}{The significance level; to calculate a 100(1-\eqn{\alpha})\% lower confidence bound.}

\item{MonteCarlo}{Number of samples to draw from the posterior distribution for the Monte Carlo estimate.}

\item{f.star}{The number of psuedo-failures to use for a component that exhibits zero observed
failures. The default value is from the log-gamma procedure proposed by Gatliffe (1976), and
is the value used by Rice and Moore.}

\item{...}{Additional arguments to be ignored.}
}
\value{
The 100(1-\eqn{\alpha})\% lower confidence bound.
}
\description{
Calculate a binomial series lower confidence bound using Rice and Moore's (1983) method.
}
\examples{
rice_moore(s=c(35, 97, 59), n=c(35, 100, 60), alpha=.10, MonteCarlo=1000)
}
