% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{applyDelay}
\alias{applyDelay}
\title{Delay effect}
\usage{
applyDelay(sample, type = "feedforward", delayTime = 0.6, echoes = c(0.8))
}
\arguments{
\item{sample}{soundSample object, input sample}

\item{type}{Character string, the delay type: feedforward or feedback}

\item{delayTime}{Numeric >0, delay time in s.}

\item{echoes}{Numeric vector >0. The size of the vector gives the number of echoes, the values the level of each echo (generally decreases to 0).}
}
\value{
The sound sample with a delay effect
}
\description{
Apply a delay to a sound sample. See https://en.wikipedia.org/wiki/Comb_filter
}
\examples{
# example code
notes=c('E3','G3','A3','B3','D4','E4','G4')
synth=getSynth(notes)
raw=as.soundSample(play.instrument(synth,notes=notes[c(1,2,3,2,3,4,3,4,5,4,5,6,5,6,7)]))
plot(raw)
\dontrun{
# All calls to function 'listen' are wrapped in \dontrun{} since
# they rely on an external audio player to listen to the audio samples.
# See ?tuneR::setWavPlayer for setting a default player.
listen(raw)}
# Single echo by default
cooked=applyDelay(raw)
plot(cooked)
\dontrun{listen(cooked)}
# Multiple echoes
cooked=applyDelay(raw,echoes=1/(1:10))
plot(cooked)
\dontrun{listen(cooked)}
# Feedback-type delay
cooked=applyDelay(raw,echoes=1/(1:10),type='feedback')
plot(cooked)
\dontrun{listen(cooked)}
}
