% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_unified_sales_report.R
\name{st_unified_sales_report}
\alias{st_unified_sales_report}
\title{Fetch Unified Sales Report Estimates (All Regional SKUs Aggregated)}
\usage{
st_unified_sales_report(
  unified_app_id,
  countries,
  start_date,
  end_date,
  date_granularity,
  auth_token = Sys.getenv("SENSORTOWER_AUTH_TOKEN"),
  verbose = TRUE
)
}
\arguments{
\item{unified_app_id}{Character string or vector. Sensor Tower unified app ID(s)
(24-character hex format, e.g., "67ec0bf3e540b65904256cc4").}

\item{countries}{Character vector. Country codes (e.g., c("US", "GB", "JP"),
or "WW" for worldwide). Required.}

\item{start_date}{Date or character string. Start date in "YYYY-MM-DD" format. Required.}

\item{end_date}{Date or character string. End date in "YYYY-MM-DD" format. Required.}

\item{date_granularity}{Character string. One of "daily", "weekly", "monthly", "quarterly". Required.}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}

\item{verbose}{Logical. If TRUE, prints progress messages.}
}
\value{
A tibble with columns:
  - `date`: Date of the data point
  - `country`: Country code
  - `unified_app_id`: The unified app ID
  - `revenue`: Revenue in dollars (converted from cents)
  - `downloads`: Number of downloads
}
\description{
Retrieves download and revenue estimates using the unified API endpoint,
which properly aggregates ALL regional SKUs (app variants from different
publishers/regions) within a unified_app_id.
}
\details{
This function solves the problem where apps like "Watcher of Realms" have
multiple regional versions (e.g., Moonton, Shanghai Moonton, Vizta Games,
Skystone Games publishers) that need to be combined for accurate totals.


**Why use this instead of st_sales_report()?**

When a game has multiple regional SKUs (same game published under different
publishers or app IDs in different regions), the standard `st_sales_report()`
function with ID resolution only fetches data for the FIRST iOS and Android
app ID. This can result in significantly undercounted revenue/downloads.

Example: "Watcher of Realms" has 4 iOS apps and 3 Android apps across
different publishers (Moonton, Vizta Games, Skystone Games, etc.). Using
`st_sales_report()` with the unified_app_id might only fetch data for
2 of these 7 apps.

This function uses the `/v1/unified/sales_report_estimates` endpoint which
automatically aggregates ALL app IDs within the unified entity.

**API Response Fields:**
The unified API returns `unified_revenue` and `unified_units` which are
automatically converted to `revenue` (dollars) and `downloads`.
}
\examples{
\dontrun{
# Get unified sales data for Watcher of Realms
sales <- st_unified_sales_report(
  unified_app_id = "67ec0bf3e540b65904256cc4",
  countries = "WW",
  start_date = "2024-01-01",
  end_date = "2024-12-31",
  date_granularity = "monthly"
)

# Multiple apps at once
sales <- st_unified_sales_report(
  unified_app_id = c("67ec0bf3e540b65904256cc4", "5ba4585f539ce75b97db6bcb"),
  countries = c("US", "GB", "JP"),
  start_date = "2024-01-01",
  end_date = "2024-12-31",
  date_granularity = "monthly"
)
}

}
