% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefs.sensmed.R
\name{grr}
\alias{grr}
\alias{grr.bb}
\alias{grr.bc}
\alias{grr.cb}
\alias{grr.cc}
\title{Analytic gradients of the loglikelihood functions for ML estimation of regression parameters}
\usage{
grr.bb(
  par,
  Rho,
  X.expl = X.expl,
  X.resp = X.resp,
  outc.resp = outc.resp,
  outc.expl = outc.expl
)

grr.bc(
  par,
  Rho,
  X.expl = X.expl,
  X.resp = X.resp,
  outc.resp = outc.resp,
  outc.expl = outc.expl
)

grr.cb(
  par,
  Rho,
  X.expl = X.expl,
  X.resp = X.resp,
  outc.resp = outc.resp,
  outc.expl = outc.expl
)

grr.cc(
  par,
  Rho,
  X.expl = X.expl,
  X.resp = X.resp,
  outc.resp = outc.resp,
  outc.expl = outc.expl
)
}
\arguments{
\item{par}{Vector of parameter values.}

\item{Rho}{The value of the sensitivity parameter.}

\item{X.expl}{The model matrix (see \code{\link{model.matrix}}) of \code{model.expl}}

\item{X.resp}{The model matrix (see \code{\link{model.matrix}}) of \code{model.resp}}

\item{outc.resp}{The outcome of \code{model.resp}, a vector.}

\item{outc.expl}{The outcome of \code{model.expl}, a column matrix.}
}
\description{
Implementation of the analytic gradients of the loglikelihood functions for ML estimation of regression parameters for different combinations of
exposure, mediator and outcome models. The functions are named according to the convention \code{grr."model.expl type""model.resp type"} where \code{b}
stands for binary probit regression and \code{c} stands for linear regression.
}
\seealso{
\code{\link{coefs.sensmed}}, \code{\link[maxLik]{maxLik}}
}
