% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{create_targets}
\alias{create_targets}
\title{Helper function for creating targets from auxiliary information and formula}
\usage{
create_targets(target_design, target_formula)
}
\arguments{
\item{target_design}{A survey object}

\item{target_formula}{A formula object that contains the variables to weight on}
}
\value{
Weighting target for survey objects
}
\description{
Returns weighting targets for survey objects.
}
\examples{
data(poll.data)
poll.svy = survey::svydesign(ids = ~ 1,
                     data = poll.data)

#Set up raking formula:
formula_rake = ~ age_buckets + educ + gender + race + educ * pid + bornagain

#Generate targets:
targets_rake = create_targets(poll.svy, formula_rake)

}
