% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenotypic_indices.R
\name{smith_hazel}
\alias{smith_hazel}
\title{Smith-Hazel Linear Phenotypic Selection Index}
\usage{
smith_hazel(
  pmat,
  gmat,
  wmat,
  wcol = 1,
  selection_intensity = 2.063,
  GAY = NULL
)
}
\arguments{
\item{pmat}{Phenotypic variance-covariance matrix (n_traits x n_traits)}

\item{gmat}{Genotypic variance-covariance matrix (n_traits x n_traits)}

\item{wmat}{Economic weights matrix (n_traits x k), or vector}

\item{wcol}{Weight column to use if wmat has multiple columns (default: 1)}

\item{selection_intensity}{Selection intensity constant (default: 2.063 for 10\% selection)}

\item{GAY}{Optional. Genetic advance of comparative trait for PRE calculation}
}
\value{
List with:
  \itemize{
    \item \code{summary} - Data frame with coefficients and metrics
    \item \code{b} - Vector of Smith-Hazel index coefficients
    \item \code{w} - Named vector of economic weights
    \item \code{Delta_G} - Named vector of expected genetic gains per trait
    \item \code{sigma_I} - Standard deviation of the index
    \item \code{GA} - Total genetic advance
    \item \code{PRE} - Percent relative efficiency
    \item \code{hI2} - Heritability of the index
    \item \code{rHI} - Accuracy (correlation with breeding objective)
  }
}
\description{
Implements the optimal Smith-Hazel selection index which maximizes
the correlation between the index I = b'y and the breeding objective H = w'g.

This is the foundational selection index method from Chapter 2.
}
\details{
\strong{Mathematical Formulation (Chapter 2):}

Index coefficients: \eqn{b = P^{-1}Gw}

Where:
- P = Phenotypic variance-covariance matrix
- G = Genotypic variance-covariance matrix
- w = Economic weights

Key metrics:
- Variance of index: \eqn{\sigma^2_I = b'Pb}
- Total genetic advance: \eqn{R_H = i\sqrt{b'Pb}}
- Expected gains per trait: \eqn{\Delta G = (i/\sigma_I)Gb}
- Heritability of index: \eqn{h^2_I = b'Gb / b'Pb}
- Accuracy: \eqn{r_{HI} = \sqrt{b'Gb / b'Pb}}
}
\examples{
\dontrun{
# Calculate variance-covariance matrices
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
pmat <- phen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])

# Define economic weights
weights <- c(10, 8, 6, 4, 2, 1, 1)

# Build Smith-Hazel index
result <- smith_hazel(pmat, gmat, weights)
print(result)
summary(result)
}
}
